<?php

define('APPDIR', __DIR__ );

require APPDIR . '/vendor/autoload.php';

require APPDIR . '/variations-config.php';
require_once APPDIR . '/inc/variations.php';
require_once APPDIR . '/inc/erpinterface.php';
require_once APPDIR . '/inc/mysql_variations.php';
require_once APPDIR . '/inc/logger.php';
require_once APPDIR . '/inc/schedule_helper.php';

use Automattic\WooCommerce\Client;
use Automattic\WooCommerce\HttpClient\HttpClientException;

$sch = new schedule_helper("rsguatemala",5, 15, "https://api.squadcast.com/v2/incidents/api/c47fe14325067052e9c55147c4ff529d58df97f6" );

if (!$sch->check()){
	die;
	exit;
}

$woo = new Client(
    CONFIG_SERVER, 
    CONFIG_CK, 
    CONFIG_CS,
    [
        'version' => 'wc/v3',
        'timeout' => '60'
    ]
);

$erp = new mysql_variations();
$product = new variations($woo, $erp);
$product->run_batch();

$sch->finish();