<?php 

include_once '../variations-config.php';

class db_install 
{
  private $db;

  public function __construct()
  {
    $mysqli = new mysqli(CONFIG_DB_HOST, CONFIG_DB_USER, CONFIG_DB_PASS, CONFIG_DB_NAME);

    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $this->db = $mysqli;
  }

  public function install()
  {
    /***************************************************/
    /*                   productos                     */
    /***************************************************/
    $this->db->query(
      "CREATE TABLE IF NOT EXISTS `" . CONFIG_DB_PREFIX . "products` (
				`sku` varchar(32) NOT NULL,
        `name` varchar(512) NOT NULL,
        `type` varchar(32) NOT NULL,
        `stock` int(11) NOT NULL DEFAULT 0,
        `price` decimal(12,2) NOT NULL DEFAULT 0.00,
        `images` json,
        `categories` varchar(512),
        `status` int(11) NOT NULL DEFAULT 1,
        `enabled` int(11) NOT NULL DEFAULT 1,
        `sale` decimal(12,2) DEFAULT NULL,
        `sale_start` datetime DEFAULT NULL,
        `sale_end` datetime DEFAULT NULL,
        `id_wp` int(11) NOT NULL DEFAULT 0,
        `last_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
        `notes` varchar(128) NOT NULL DEFAULT '',
				PRIMARY KEY (`sku`),
				INDEX(`status`, `id_wp`)
			) 
			ENGINE=InnoDB DEFAULT CHARSET=utf8;"
    );

    /***************************************************/
    /*                  variaciones                    */
    /***************************************************/
    $this->db->query(
      "CREATE TABLE IF NOT EXISTS `" . CONFIG_DB_PREFIX . "variations` (
				`sku` varchar(32) NOT NULL,
        `talla` varchar(8) NOT NULL,
        `stock` int(11) NOT NULL DEFAULT 0,
        `price` decimal(12,2) NOT NULL DEFAULT 0.00,
        `status` int(11) NOT NULL DEFAULT 1,
        `enabled` int(11) NOT NULL DEFAULT 1,
        `sale` decimal(12,2) DEFAULT NULL,
        `sale_start` datetime DEFAULT NULL,
        `sale_end` datetime DEFAULT NULL,
        `id_wp` int(11) NOT NULL DEFAULT 0,
        `parent_sku` varchar(32) NOT NULL DEFAULT 0,
        `last_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
				`notes` varchar(128) NOT NULL DEFAULT '',
        PRIMARY KEY (`sku`),
				INDEX(`status`, `id_wp`)
			) 
			ENGINE=InnoDB DEFAULT CHARSET=utf8;"
    );

    /***************************************************/
    /*                   categorías                    */
    /***************************************************/
    $this->db->query(
      "CREATE TABLE IF NOT EXISTS `" . CONFIG_DB_PREFIX . "categories` (
        `id_wp` int(11) NOT NULL DEFAULT 0,
        `id_parent` int(11) NOT NULL DEFAULT 0,
        `name` varchar(128) NOT NULL,
        PRIMARY KEY (`id_wp`),
        INDEX(`id_parent`)
      )
      ENGINE=InnoDB DEFAULT CHARSET=utf8;"
    );

    /***************************************************/
    /*                      log                       */
    /***************************************************/
    $this->db->query(
      "CREATE TABLE IF NOT EXISTS `" . CONFIG_DB_PREFIX . "log` (
				`logid` int(11) NOT NULL,
        `time` timestamp NOT NULL DEFAULT current_timestamp(),
        `severity` varchar(16) NOT NULL,
        `message` varchar(4096) NOT NULL,
				PRIMARY KEY (`logid`)
			) 
			ENGINE=InnoDB DEFAULT CHARSET=utf8;"
    );

    /***************************************************/
    /*            procedimientos almacenados           */
    /***************************************************/
    /*================= UPDATE PRODUCTS ===============*/
    $this->db->query("DROP PROCEDURE `". CONFIG_DB_PREFIX ."sp_update_products`");
    $this->db->query(
      "
        CREATE PROCEDURE `". CONFIG_DB_PREFIX ."sp_update_products`(
          in sku varchar(32),
          in price decimal(12,1)
        )
        BEGIN
        INSERT INTO `". CONFIG_DB_PREFIX ."products` (sku, price, enabled, status)
        VALUES (sku, price, 1, 1)
        ON DUPLICATE KEY UPDATE
        `". CONFIG_DB_PREFIX ."products`.enabled = 1;
        END;
      "
    );

    /*================ UPDATE VARIATIONS ==============*/
    $this->db->query("DROP PROCEDURE `". CONFIG_DB_PREFIX ."sp_update_variations`");
    $this->db->query(
      "
        CREATE PROCEDURE `". CONFIG_DB_PREFIX ."sp_update_variations`(
          in sku varchar(32),
          in talla varchar(32),
          in stock int(11),
          in price decimal(12,1),
          in parent_sku varchar(32)  
        )
        BEGIN
        INSERT INTO `". CONFIG_DB_PREFIX ."variations` (sku, talla, stock, price, parent_sku, enabled, status)
        VALUES (sku, talla, stock, price, parent_sku, 1, 1)
        ON DUPLICATE KEY UPDATE status = IF((`". CONFIG_DB_PREFIX ."variations`.stock != stock OR `". CONFIG_DB_PREFIX ."variations`.price != price) AND `". CONFIG_DB_PREFIX ."variations`.status = 2, 1, status),
        `". CONFIG_DB_PREFIX ."variations`.stock = stock,
        `". CONFIG_DB_PREFIX ."variations`.price = price,
        `". CONFIG_DB_PREFIX ."variations`.enabled = 1;
        END;
      "
    );
  }
}

$install = new db_install();
$install->install();