CREATE TABLE `log` (
  `logid` int(11) NOT NULL,
  `time` timestamp NOT NULL DEFAULT current_timestamp(),
  `severity` varchar(16) NOT NULL,
  `message` varchar(4096) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `molvu_products` (
  `sku` varchar(32) NOT NULL,
  `name` varchar(128) NOT NULL,
  `stock` int(11) NOT NULL DEFAULT 0,
  `price` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` int(11) NOT NULL DEFAULT 1,
  `sale` decimal(12,2) DEFAULT NULL,
  `sale_start` datetime DEFAULT NULL,
  `sale_end` datetime DEFAULT NULL,
  `id_wp` int(11) NOT NULL DEFAULT 0,
  `enabled` int(11) NOT NULL DEFAULT '1',
  `last_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `notes` varchar(128) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Indices de la tabla `log`
--
ALTER TABLE `log`
  ADD PRIMARY KEY (`logid`);

--
-- Indices de la tabla `molvu_products`
--
ALTER TABLE `molvu_products`
  ADD PRIMARY KEY (`sku`),
  ADD KEY `index_molvu_products` (`status`,`id_wp`) USING BTREE;

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `log`
--
ALTER TABLE `log`
  MODIFY `logid` int(11) NOT NULL AUTO_INCREMENT;


DELIMITER $$

CREATE PROCEDURE `sp_update_product`(
	in product JSON
)
BEGIN

	DECLARE model VARCHAR(32) DEFAULT JSON_UNQUOTE(JSON_EXTRACT(product, '$.model'));
    DECLARE name VARCHAR(128) DEFAULT JSON_UNQUOTE(JSON_EXTRACT(product, '$.name'));
    DECLARE quantity INT(11) DEFAULT JSON_UNQUOTE(JSON_EXTRACT(product, '$.quantity'));
    DECLARE price DECIMAL(12,2) DEFAULT JSON_UNQUOTE(JSON_EXTRACT(product, '$.price'));
    DECLARE sale_price DECIMAL(12,2) DEFAULT JSON_UNQUOTE(JSON_EXTRACT(product, '$.sale_price'));
    DECLARE sale_start DATETIME DEFAULT JSON_UNQUOTE(JSON_EXTRACT(product, '$.sale_start'));
    DECLARE sale_end DATETIME DEFAULT JSON_UNQUOTE(JSON_EXTRACT(product, '$.sale_end'));
    DECLARE enabled INT(11) DEFAULT JSON_UNQUOTE(JSON_EXTRACT(product, '$.enabled'));

    INSERT INTO `molvu_products` (sku, name, stock, price, sale, sale_start, sale_end, enabled)
    VALUES (model, name, quantity, price, sale_price, sale_start, sale_end, enabled) ON DUPLICATE KEY UPDATE    
    status = IF(`molvu_products`.stock != quantity OR `molvu_products`.price != price OR `molvu_products`.sale != sale_price OR `molvu_products`.sale_start != sale_start OR `molvu_products`.sale_end != sale_end OR `molvu_products`.enabled != enabled, 1, status),
    `molvu_products`.stock = quantity,
    `molvu_products`.price = price,
    `molvu_products`.sale = sale_price,
    `molvu_products`.sale_start = sale_start,
    `molvu_products`.sale_end = sale_end,
    `molvu_products`.`enabled` = enabled;

END$$


CREATE PROCEDURE `sp_update_all_products`(
	IN all_data JSON
)
BEGIN

	DECLARE i INT UNSIGNED DEFAULT 0;
	DECLARE v_count INT UNSIGNED DEFAULT JSON_LENGTH(all_data);
	DECLARE v_current_item JSON DEFAULT NULL;
	DECLARE sql_update_product VARCHAR(500)	DEFAULT '';
	
	WHILE i < v_count DO		
		SET v_current_item := JSON_EXTRACT(all_data, CONCAT('$[', i, ']'));
        SET @sql_update_product := CONCAT('CALL sp_update_product ', '(''', v_current_item, ''');');
        PREPARE sql_update_product FROM @sql_update_product;
        EXECUTE sql_update_product;
        DEALLOCATE PREPARE sql_update_product;
		SET i := i+1;
    END WHILE;
    
END$$

DELIMITER ;