/***************************************************/
/*                   productos                     */
/***************************************************/
CREATE TABLE `products` (
  `sku` varchar(32) NOT NULL,
  `name` varchar(128) NOT NULL,
  `stock` int(11) NOT NULL DEFAULT 0,
  `price` decimal(12,2) NOT NULL DEFAULT 0.00,
  `images` varchar(128),
  `categories` varchar(256),
  `status` int(11) NOT NULL DEFAULT 1,
  `enabled` int(11) NOT NULL,
  `sale` decimal(12,2) DEFAULT NULL,
  `sale_start` datetime DEFAULT NULL,
  `sale_end` datetime DEFAULT NULL,
  `id_wp` int(11) NOT NULL DEFAULT 0,
  `last_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `notes` varchar(128) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `products`
  ADD PRIMARY KEY (`sku`),
  ADD KEY `index_products` (`status`,`id_wp`) USING BTREE;



/***************************************************/
/*                   categorías                    */
/***************************************************/
CREATE TABLE `categories` (
  `id_wp` int(11) NOT NULL DEFAULT 0,
  `id_parent` int(11) NOT NULL DEFAULT 0,
  `name` varchar(128) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `categories`
  ADD PRIMARY KEY (`id_wp`),
  ADD KEY `index_categories` (`id_parent`) USING BTREE;



/***************************************************/
/*                      log                       */
/***************************************************/
CREATE TABLE `log` (
  `logid` int(11) NOT NULL,
  `time` timestamp NOT NULL DEFAULT current_timestamp(),
  `severity` varchar(16) NOT NULL,
  `message` varchar(4096) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `log`
  ADD PRIMARY KEY (`logid`);



/***************************************************/
/*            procedimiento almacenado            */
/***************************************************/ 
DELIMITER $$
CREATE PROCEDURE sp_update_product(
    in sku varchar(32),
    in name varchar(128),
    in stock int(11),
    in price decimal(12,1),
    in images varchar(128),
    in categories varchar(256),
    in enabled int(11)  
)

BEGIN 
    INSERT INTO `products` (sku, name, stock, price, images,categories, enabled)
    VALUES (sku, name, stock, price, images, categories, enabled)
    ON DUPLICATE KEY UPDATE status = IF
    (products.name != name OR products.stock != stock OR products.images != images OR products.categories != categories OR products.price != price OR products.enabled != enabled, 1, status),
    `products`.`name` = name,
    `products`.stock = stock,
    `products`.price = price, 
    `products`.images = images,
    `products`.categories = categories,
    `products`.`enabled` = enabled;
END$$