<?php 

  include_once '../variations-config.php';
  include_once '../rsguatemala-config.php';
  include_once './db_rsguatemala.php';
  include_once './logger.php';
    include_once './squadcast.php';
  class ws_rsguatemala {
    private $db;
    private $db_rsguatemala;
    private $update_db_rsguatemala;
    private $logger;

    public function __construct()
    {
      $mysqli = new mysqli(CONFIG_DB_HOST, CONFIG_DB_USER, CONFIG_DB_PASS, CONFIG_DB_NAME);

      if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
      }

      $this->logger = new logger('info.log');
      $this->db = $mysqli;
      $this->db_rsguatemala = new db_rsguatemala();
      $this->update_db_rsguatemala = $this->db_rsguatemala->update_data();
    }

    public function save_data() {
      try {
        $items = $this->db_rsguatemala->get_data();

        $query_products = '';
        $query_variations = '';        
        $query_rsguatemala_db = '';

        if (count($items) <= 0) {
          return false;
        }

        for ($i = 0; $i < count($items); $i++) {
          $parent_sku = $items[$i]['codigo'];
          $talla = $items[$i]['talla'];
          $sku = $parent_sku . '-' . $talla;
          $stock = $items[$i]['inventario'];
          $price = $items[$i]['precio'];

          $query_products .= "CALL ".CONFIG_DB_PREFIX."sp_update_products('".$parent_sku."', '".$price."');";
          $query_variations .= "CALL ".CONFIG_DB_PREFIX."sp_update_variations('".$sku."','".$talla."','".$stock."','".$price."','".$parent_sku."');";
          $query_rsguatemala_db .= "UPDATE ".CONFIG_DB_NAME_RS.".".CONFIG_DB_TABLE_RS." SET inventarioweb = '". $stock ."' WHERE codigo = '". $parent_sku ."' AND talla = '". $talla ."'; ";

          if (($i+1) % 10 == 0){
            if ($this->db->multi_query($query_products)) {
              while($this->db->more_results() && $this->db->next_result()){;}
            } else {
              throw new ErrorException('Error al cargar data en la tabla de productos');
            }

            if ($this->db->multi_query($query_variations)) {
              while($this->db->more_results() && $this->db->next_result()){;}
            } else {
              throw new ErrorException('Error al cargar data en la tabla de variaciones');
            }

            if ($this->update_db_rsguatemala->multi_query($query_rsguatemala_db)) {
              while($this->update_db_rsguatemala->more_results() && $this->update_db_rsguatemala->next_result()){;}
            } else {
              throw new ErrorException('Error al actualizar la tabla en RSGUATEMALA');
            }

            $query_products = '';
            $query_variations = '';
            $query_rsguatemala_db = '';
          }
        }

        if (!empty($query_products) && !empty($query_variations) && !empty($query_rsguatemala_db)) {
          if ($this->db->multi_query($query_products)) {
            while($this->db->more_results() && $this->db->next_result()){;}
          } else {
            throw new ErrorException('Error al cargar data en la tabla de productos');
          }

          if ($this->db->multi_query($query_variations)) {
            while($this->db->more_results() && $this->db->next_result()){;}
          } else {
            throw new ErrorException('Error al cargar data en la tabla de variaciones');
          }

          if ($this->update_db_rsguatemala->multi_query($query_rsguatemala_db)) {
            while($this->update_db_rsguatemala->more_results() && $this->update_db_rsguatemala->next_result()){;}
          } else {
            throw new ErrorException('Error al actualizar la tabla en RSGUATEMALA');
          }

          $query_products = '';
          $query_variations = '';
          $query_rsguatemala_db = '';
        }
      } catch (Exception $e) {
        $this->logger->e("Error: " . $e->getMessage());
        squadcast::alert(SQDC_MESSAGE, "Error al consumir y actualizar la base de datos", 2, SQDC_SERVER, SQDC_CLIENT, API_URL_SQUADCAST);
      }
    }
  }

  $ws = new ws_rsguatemala();
  $ws->save_data();