<?php

if (!defined('UPDATE_PRICE')) define('UPDATE_PRICE',true);
if (!defined('UPDATE_STOCK')) define('UPDATE_STOCK',true);
if (!defined('UPDATE_TALLA')) define('UPDATE_TALLA', true);
if (!defined('UPDATE_SALE')) define('UPDATE_SALE',true);
if (!defined('UPDATE_STATUS')) define('UPDATE_STATUS',true);

if (!defined('CREATE_PRICE')) define('CREATE_PRICE',true);
if (!defined('CREATE_STOCK')) define('CREATE_STOCK',true);
if (!defined('CREATE_TALLA')) define('CREATE_TALLA', true);
if (!defined('CREATE_SALE')) define('CREATE_SALE',true);
if (!defined('CREATE_STATUS')) define('CREATE_STATUS',true);

require_once 'squadcast.php';

/**
 * Product class to update products based on an sync db
 */
class variations{
	private $woo;
	private $erp;
	private $options;

	private $logger;

	private $batch;
	private $batch_count;
	
	private $current_parent_id;
	private $previous_parent_id;
	private $parent_ids;
	private $product_parent_id;
	
	private $hora_actual;

	/**
	 * Constructor.
	 * @param WooCommerce\Client $woo_connection The woocommerce API connection object
	 * @param erpinterface		 $erp_connection The object that implements the erp interface
	 */
	function __construct($woo_connection, $erp_connection, $options = array()) {
		$this->woo = $woo_connection;
		$this->erp = $erp_connection;
		$this->options = $options;

		$params = array();
		$params['db_log'] = $this->erp;
		if (isset($_GET['do_echo'])) {
			$params['do_echo'] = true;
		}

		$this->logger = new logger('prouctos.log', $params);

		//Initialize batch
		$this->batch = array();
		$this->batch_count = 0;

		$this->previous_parent_id = '';
		$this->current_parent_id = '';
		$this->parent_ids = array();
		$this->product_parent_id = 0;

		$this->hora_actual = time();
	}

	/**
	 * Starts update process using batch approach
	 * @return [type] [description]
	 */
	public function run_batch() {
		$tiempo_a_correr = RUN_TIME . " seconds";
    $detener_proceso	= strtotime($tiempo_a_correr, $this->hora_actual);
		
		$error_count = 0;
		
		$i = 0;

		$products = $this->erp->get_products();

		$this->logger->i('Starting product variations update');

		while (($i < count($products)) && ($this->hora_actual < $detener_proceso)) {
			$this->logger->d('Processing product variation'.print_r($products[$i],1));
			
			$this->product_parent_id = $this->get_parent($products[$i]);

			if ($this->product_parent_id > 0) {
				$this->previous_parent_id = $this->current_parent_id;
				$this->current_parent_id = $this->product_parent_id;

				$product_id = $products[$i]['id_wp'];

				try {
					if ($this->previous_parent_id == $this->current_parent_id || $i == 0) {
						if ($product_id <= 0) {
							$product_id = $this->get_id($products[$i], $this->product_parent_id);
							
							if ($product_id > 0) {
			
								$this->logger->d("Fetched product_id ".$product_id);
			
								$this->erp->update_product_id($products[$i]['sku'], $product_id, '');
			
								$products[$i]['id_wp'] = $product_id;
								$this->add_update_product($products[$i]);
			
							} else {	
								$product_id = $this->add_create_product($products[$i]);
							}
						} else {
							$this->add_update_product($products[$i]);
						}
					} else {
						$this->send_batch($this->previous_parent_id);
						$i -= 1;
					}
				} catch (Exception $e) {
					$error_count++;
					
					if ($error_count == 1) {
						squadcast::alert(SQDC_MESSAGE, SQDC_DESCRIPTION . $error_count . " producto", 1, SQDC_SERVER, SQDC_CLIENT, API_URL_SQUADCAST);
					}
					
					$this->logger->e('Error al procesar producto ' . $products[$i]['sku'] . ' ' . $e);
				} 
			} else {
			    $this->erp->set_status_sku($products[$i]['sku']);
			}
			
			$i += 1;
			$this->hora_actual = time();
		}
		
		try {
			$this->send_batch($this->product_parent_id);
		} catch (Exception $e) {
			$error_count++;
			
			if ($error_count == 1) {
				squadcast::alert(SQDC_MESSAGE, SQDC_DESCRIPTION . $error_count . " producto", 1, SQDC_SERVER, SQDC_CLIENT, API_URL_SQUADCAST);
			}
			
			$this->logger->e('Error al procesar productos ' . $e);
		} 

		if ($error_count > 1) {
			squadcast::alert(SQDC_MESSAGE, SQDC_DESCRIPTION . $error_count . " productos", 4, SQDC_SERVER, SQDC_CLIENT, API_URL_SQUADCAST);
		}

		$this->logger->i('Finished product update');

		$this->erp->close_connection();
	}

	public function get_parent($product_data) {
		$product_parent_id = $product_data['parent_id'];

		try {
			if ($product_parent_id <= 0) {
				if (isset($this->parent_ids[$product_data['parent_sku']])) {
					$product_parent_id = $this->parent_ids[$product_data['parent_sku']];
				} else {
					$product_parent_id = $this->get_parent_id($product_data);

					if ($product_parent_id > 0) {
						$this->erp->update_product_parent_id($product_data['parent_sku'], $product_parent_id);

						$this->parent_ids[$product_data['parent_sku']] = $product_parent_id;
					}
				}
			} else {
				if (!isset($this->parent_ids[$product_data['parent_sku']])) {
					$this->parent_ids[$product_data['parent_sku']] = $product_parent_id;
				}
			}

			return $product_parent_id;
		} catch (Exception $e) {
			$this->logger->e('Error al obtener el parent_id ' . $e);
		}
	}

	public function get_parent_id($product_data) {
		try {
			$product = $this->woo->get('products', array('sku'=>$product_data['parent_sku']));

			if (count($product) < 1) {
				return -1;
			} else {
				return $product[0]->id;
			}
		} catch (HttpClientException $e) {
			$this->output_woo_exception($e);
			return -1;
		}
	}

		/**
	 * Gets the Woo ID of a product based on it's SKU
	 * @param  array $product_data The ID or SKU based on the ERP
	 * @param  int $product_parent_id The ID of parent product
	 * @return int         The Woo ID or -1 if error
	 */
	public function get_id($product_data, $product_parent_id) {
		try {
			$product = $this->woo->get('products/' . $product_parent_id . '/variations', array('sku'=>$product_data['sku']));

			if (count($product) < 1) {
				return -1;
			} else {
				return $product[0]->id;
			}
		} catch (HttpClientException $e) {
			$this->output_woo_exception($e);
			return -1;
		}
	}

		/**
	 * Ads a creates new product to the batch on Woo based on the ERP info
	 * @param  array $product_data	the product to create
	 */
	public function add_create_product($product_data) {
		$data = array (
			'sku' => $product_data['sku'],
		);

		if (CREATE_PRICE && isset($product_data['price'])) {
			$data['regular_price'] = $product_data['price'];
		}

		if (CREATE_STOCK && isset($product_data['stock'])) {
			$data['stock_quantity'] = $product_data['stock'];
			$data['manage_stock'] = true;
		}

		if (CREATE_TALLA && isset($product_data['talla'])) {
			$data['attributes'] = array();
			$data['attributes'][] = array(
					'id' => 1,
					'option' => $product_data['talla']
			);
		}

		if (CREATE_SALE && isset($product_data['sale'])) {
			$data['sale_price'] = $product_data['sale'];
			$data['date_on_sale_from'] = $product_data['sale_start'];
			$data['date_on_sale_to'] = $product_data['sale_end'];
		}

		if (CREATE_STATUS) {
			switch ($product_data['enabled']) {
				case 0:
					$data['status'] = 'pending';
					break;
				
				case 1:
					$data['status'] = 'draft';
					break;

				default:
					# code...
					break;
			}
		}

		$this->add_create($data);
	}

	/**
	 * Adds a product to be created to the batch
	 * @param array $item Product to be created
	*/
	private function add_create($item) {
		$this->add_call($item, "create");
	}

	/**
	 * Adds a product update to the batch on Woo based on data from ERP
	 * @param  array 	$product_data	Product data array
	 */
	public function add_update_product($product_data) {
		$data = array (
			'id' => $product_data['id_wp']
		);

		if (UPDATE_PRICE && isset($product_data['price'])) {
			$data['regular_price'] = $product_data['price'];
		}

		if (UPDATE_STOCK && isset($product_data['stock'])) {
			$data['stock_quantity'] = $product_data['stock'];
			$data['manage_stock'] = true;
		}

		if (UPDATE_TALLA && isset($product_data['talla'])) {
			$data['attributes'] = array();
			$data['attributes'][] = array(
					'id' => 1,
					'option' => $product_data['talla']
			);
		}

		if (UPDATE_SALE && isset($product_data['sale'])) {
			$data['sale_price'] = $product_data['sale'];
			$data['date_on_sale_from'] = $product_data['sale_start'];
			$data['date_on_sale_to'] = $product_data['sale_end'];
		}

		if ( UPDATE_STATUS ) {
			switch ($product_data['enabled']) {
				case 0:
					$data['status'] = 'pending';
					break;
				
				case 1:
					$data['status'] = 'publish';
					break;

				default:
					# code...
					break;
			}
		}

		$this->add_update($data);
	}

	/**
	 * Adds a product to be updated to the batch
	 * @param array $item Product to be updated
	 */
	private function add_update($item) {
		$this->add_call($item, "update");
	}

	/**
	 * Adds a product to the batch
	 * @param array $item Product to be added
	 * @param string $type Type of update (create/update/delete)
	 */
	private function add_call($item, $type) {
		$this->batch[$type][] = $item;
		
		$this->batch_count++;
	}

	/**
	 * Sends current batch
	*/
	private function send_batch($parent_id) {
		if ($this->batch_count <= 0)
			return;

		try {
			$this->logger->d("Sending batch ".print_r($this->batch,1));
			$this->process_batch_result( $this->woo->post('products/' . $parent_id . '/variations/batch', $this->batch) );
		} catch (HttpClientException $e) {
			$this->output_woo_exception($e);

			$this->logger->e("Error updating batch");
		} finally {
			$this->batch_count = 0;

			$this->batch = array();
		}
	}

	/**
	 * Process the batch results to update IDs and log exceptions.
	 * @param  object $results The results from woo batch update
	 */
	private function process_batch_result($results) {
		if (isset($results->create)) {
			foreach ($results->create as $product) {
				if (!isset($product->error)) {
					/*
						If no errors update wp_id and set status 2 -> updated
					*/

					$this->erp->update_product_id($product->sku, $product->id, '');
					$this->logger->i("Created product ".$product->id);
					$this->erp->set_status($product->id);
				}
				else {
					$this->logger->e("Error creating product ".json_encode($product, JSON_UNESCAPED_SLASHES |    JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_PARTIAL_OUTPUT_ON_ERROR | JSON_INVALID_UTF8_SUBSTITUTE));
				}
			}
		}

		if (isset($results->update)) {
			foreach ($results->update as $product) {
				if (!isset($product->error)) {
					$this->erp->set_status($product->id);
				} else {
					$this->logger->e("Error updating product.".json_encode($product, JSON_UNESCAPED_SLASHES |    JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_PARTIAL_OUTPUT_ON_ERROR | JSON_INVALID_UTF8_SUBSTITUTE));

					if (isset($product->id)) {
						$this->logger->i("Attempting to reset wp_id ".$product->id);
						$this->erp->reset_wp_id($product->id);
					}
				}
			}
		}

	}

	private function output_woo_exception($e) {
		$this->logger->e(print_r( $e->getMessage(), true ));  // Error message.
		$this->logger->d(print_r( $e->getRequest(), true ));  // Last request data.
		$this->logger->d(print_r( $e->getResponse(), true )); // Last response data.
	}

	private function output_woo_data() {
		// Last request data.
		$lastRequest = $this->woo->http->getRequest();
		echo '<pre>Request URL: <code>' . print_r( $lastRequest->getUrl(), true ) . '</code></pre>'; // Requested URL (string).
		echo '<pre>Method: <code>' . print_r( $lastRequest->getMethod(), true ) . '</code></pre>'; // Request method (string).
		echo '<pre>Paramters: <code>' . print_r( $lastRequest->getParameters(), true ) . '</code></pre>'; // Request parameters (array).
		echo '<pre>Headers: <code>' . print_r( $lastRequest->getHeaders(), true ) . '</code></pre>'; // Request headers (array).
		echo '<pre>Body: <code>' . print_r( $lastRequest->getBody(), true ) . '</code></pre>'; // Request body (JSON).

		// Last response data.
		$lastResponse = $this->woo->http->getResponse();
		echo '<pre>Response Code: <code>' . print_r( $lastResponse->getCode(), true ) . '</code></pre>'; // Response code (int).
		echo '<pre>Headers: <code>' . print_r( $lastResponse->getHeaders(), true ) . '</code></pre>'; // Response headers (array).
		echo '<pre>Body: <code>' . print_r( $lastResponse->getBody(), true ) . '</code></pre>'; // Response body (JSON).
	}
}