<?php
	require_once 'erpinterface.php';

	/**
	 * Data class to interact with intcomex DB
	*/
	class mysql_variations implements erpinterface {

		private $db;

		/**
		 * Class constructor
		*/
		public function __construct() {

			$mysqli = new mysqli(CONFIG_DB_HOST, CONFIG_DB_USER, CONFIG_DB_PASS, CONFIG_DB_NAME);

			/* check connection */
			if (mysqli_connect_errno()) {
					printf("Connect failed: %s\n", mysqli_connect_error());
					exit();
			}

			$mysqli->query("SET NAMES utf8 COLLATE utf8_general_ci");
    	$this->db = $mysqli;
		}

		/**
		 * Gets a price ending in 9 (ceil)
		 * @param  float $price 	price to be reformatted
		 * @return int          	formatted price
		 */
		private function powerOf9($price){
			return intdiv($price, 10) * 10 + 9;
		}

		/**
		 * Gets the products to be updated from ERP to WOO
		 * @return array List of products to update
		*/
		public function get_products() : array {
			$hora_actual = date('H:i');
		  $hora_inicio = '00:00';
		  $hora_fin = '24:00';

		  if ($hora_actual < $hora_inicio || $hora_actual > $hora_fin) {
			  return array();
		  } else {
			  $stmt = $this->db->prepare("SELECT v.`sku`, v.`talla`, v.`stock`, v.`price`, v.`status`, v.`enabled`, v.`sale`, v.`sale_start`, v.`sale_end`, v.`id_wp`, v.`parent_sku`, p.`id_wp` as parent_id FROM `" . CONFIG_DB_PREFIX . "variations` v INNER JOIN `" . CONFIG_DB_PREFIX . "products` p ON v.`parent_sku` = p.`sku` WHERE v.`status` = 1 ORDER BY v.`parent_sku` ASC");

			  $stmt->execute();

			  $result = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
			
			  return $result;
		  }
		}

		public function set_status_sku($sku, $status = 2) {
			$stmt = $this->db->prepare("UPDATE `" . CONFIG_DB_PREFIX . "variations` SET `status`=? WHERE `sku` = ?");

			$stmt->bind_param("ss", $status, $sku);

			$stmt->execute();
			$stmt->close();

			return true;
		} 

		/**
		 * Updates the wp id of a product
		 * @param  string $sku ID in ERP
		 * @param  int    $wp_id  ID in Woo
		 * @param  string $notes  Notes if unable to find/create product
		 * @return bool 		  true if updated
		*/
		public function update_product_id($sku, $wp_id, $notes) : bool {

			$stmt = $this->db->prepare("UPDATE `" . CONFIG_DB_PREFIX . "variations` SET `id_wp`=?, `notes`=? WHERE `sku` = ?");

			$stmt->bind_param("sss", $wp_id, $notes, $sku);

			$stmt->execute();
			$stmt->close();

			return true;
		}

		public function update_product_parent_id($sku, $wp_id) {
			$stmt = $this->db->prepare("UPDATE `" . CONFIG_DB_PREFIX . "products` SET `id_wp`=? WHERE `sku` = ?");

			$stmt->bind_param("ss", $wp_id, $sku);

			$stmt->execute();
			$stmt->close();

			return true;
		}

		/**
		 * Resets a wordpress ID to attempt to find product again or create it
		 * @param  integer $wp_id the woo id to reset
		*/
		public function reset_wp_id($wp_id) : bool {
			$stmt = $this->db->prepare("UPDATE `" . CONFIG_DB_PREFIX . "variations` SET `id_wp`=-1 WHERE `id_wp` = ?");

			$stmt->bind_param("s", $wp_id);

			$stmt->execute();
			$stmt->close();

			return true;
		}

		/**
		 * Closes de DB connection
		*/
		public function close_connection() {
			$this->db->close();
		}

		/**
		 * Logs event to the corresponding log table
		 * @param  string $severity Severity of the message
		 * @param  string $message  Message to log
		*/
		public function log_event($severity, $message) {
			$stmt = $this->db->prepare("INSERT INTO `" . CONFIG_DB_PREFIX . "log` (`severity`, `message`) VALUES (?, ?)");
			$stmt->bind_param("ss", $severity, $message);
			
			$stmt->execute();
			$stmt->close();
		}

		/**
		 * Sets the status of a product
		 * @param string  $wp_id the wordpress id
		 * @param integer $status the status to be set
		*/
		public function set_status($id_wp, $status = 2) : bool {
			$stmt = $this->db->prepare("UPDATE `" . CONFIG_DB_PREFIX . "variations` SET `status`=? WHERE `id_wp` = ?");

			$stmt->bind_param("ss", $status, $id_wp);

			$stmt->execute();
			$stmt->close();

			return true;
		}
	}