<?php
require_once 'erpinterface.php';

/**
 * Data class to interact with molvu DB
 */
class mysql_molvu implements erpinterface {

	private $db;
	private $products_table = 'molvu_products';
	private $log_table = 'log';

	/**
	 * Class constructor
	 */
	public function __construct() {

		$mysqli = new mysqli(MOLVU_DB_HOST, MOLVU_DB_USER, MOLVU_DB_PASS, MOLVU_DB_NAME);
		$mysqli->set_charset("utf8");

		/* check connection */
		if (mysqli_connect_errno()) {
		    printf("Connect failed: %s\n", mysqli_connect_error());
		    exit();
		}

		$this->db = $mysqli;

	}

	/**
	 * Gets the products to be updated from ERP to WOO
	 * @return array List of products to update
	 */
	public function get_products() : array {

		$this->update_from_file();		

		$stmt = $this->db->prepare("SELECT * FROM `" . $this->products_table . "` WHERE status = 1");

		$stmt->execute();

		$result = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

		return $result;

		//print_r($result);		
	}

	/**
	 * Updates the wp id of a product
	 * @param  string $sku ID in ERP
	 * @param  int    $wp_id  ID in Woo
	 * @param  string $notes  Notes if unable to find/create product
	 * @return bool 		  true if updated
	 */
	public function update_product_id($sku, $wp_id, $notes) : bool {

		$stmt = $this->db->prepare("UPDATE `" . $this->products_table . "` SET `id_wp`=?, `notes`=? WHERE `sku` = ?");

		$stmt->bind_param("sss", $wp_id, $notes, $sku);

		$stmt->execute();
		$stmt->close();

		return true;

	}

	/**
	 * Resets a wordpress ID to attempt to find product again or create it
	 * @param  integer $wp_id the woo id to reset
	 */
	public function reset_wp_id($wp_id) : bool {

		$stmt = $this->db->prepare("UPDATE `" . $this->products_table . "` SET `id_wp`=-1 WHERE `id_wp` = ?");

		$stmt->bind_param("s", $wp_id);

		$stmt->execute();
		$stmt->close();

		return true;

	}

	/**
	 * Closes de DB connection
	 */
	public function close_connection() {

		$this->db->close();

	}

	/**
	 * Logs event to the corresponding log table
	 * @param  string $severity Severity of the message
	 * @param  string $message  Message to log
	 */
	public function log_event($severity, $message) {
		$stmt = $this->db->prepare("INSERT INTO `" . $this->log_table . "` (`severity`, `message`) VALUES (?, ?)");

        $stmt->bind_param("ss", $severity, $message);

        $stmt->execute();
        $stmt->close();
	}

	/**
	 * Sets the status of a product
	 * @param string  $sku the sap_id
	 * @param integer $status the status to be set
	 */
	public function set_status($sku, $status = 2) : bool {

		$stmt = $this->db->prepare("UPDATE `" . $this->products_table . "` SET `status`=? WHERE `sku` = ?");

		$stmt->bind_param("ss", $status, $sku);

		$stmt->execute();
		$stmt->close();

		return true;

	}

	private function get_data($url)
	{
		$ch = curl_init();
		$timeout = 15;
		curl_setopt($ch,CURLOPT_URL,$url);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
		curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);
		$data = curl_exec($ch);
		curl_close($ch);
		return $data;
	}

	private function update_from_file() {
		$json = $this->get_data(CONFIG_PRODUCTS_JSON_URL);

		$products = json_decode($json, TRUE);

		$products_to_send = array();

		for ($i = 0; $i < count($products); $i++) {
			
			$product_values = array();


			$product_values['model'] = $products[$i]['model'];
			$product_values['name'] = $products[$i]['name'];
			$product_values['quantity'] = $products[$i]['quantity'];
			$product_values['price'] = $products[$i]['price'];
			$product_values['enabled'] = $products[$i]['enabled'];
			if (count($products[$i]['allSales']) > 0) {
				$product_values['sale_price'] = $products[$i]['allSales'][0]['price'];
				$product_values['sale_start'] = $products[$i]['allSales'][0]['date_start'];
				$product_values['sale_end'] = $products[$i]['allSales'][0]['date_end'];

				if ($product_values['sale_start'] == '0000-00-00') {
					$product_values['sale_start'] = '2000-01-01';
				}

				if ($product_values['sale_end'] == '0000-00-00') {
					$product_values['sale_end'] = '2099-01-01';
				}
			}

			array_push($products_to_send, $product_values);
						
			if (count($products_to_send) == CONFIG_PRODUCTS_COUNT) {
				$this->update_db_json(json_encode($products_to_send));
				unset($products_to_send);
				$products_to_send = array();
			}			
		}		

		if (count($products_to_send) > 0) {
			$this->update_db_json(json_encode($products_to_send));
		}
	}

	private function update_db_json($json) {		
		$stmt = $this->db->prepare("CALL sp_update_all_products(?)");
		$stmt->bind_param("s", $json);

		$stmt->execute();
		$stmt->close();
	}

	private function update_from_file_old() {
	
		$json = $this->get_data(CONFIG_PRODUCTS_JSON_URL);

		$products = json_decode($json, TRUE);

		for ($i = 0; $i < count($products); $i++) {
			
			if (count($products[$i]['allSales']) > 0) {				
				$sale = $products[$i]['allSales'][0]['price'];
				$sale_start = $products[$i]['allSales'][0]['date_start'];
				$sale_end = $products[$i]['allSales'][0]['date_end'];
			}
			else {
				$sale = NULL;
				$sale_start = NULL;
				$sale_end = NULL;
			}
						
			$stmt = $this->db->prepare("CALL sp_update_product(?, ?, ?, ?, ?, ?, ?)");
			$stmt->bind_param("ssiddss", $products[$i]['model'], $products[$i]['name'], $products[$i]['quantity'], $products[$i]['price'], $sale, $sale_start, $sale_end);

			$stmt->execute();
			$stmt->close();
			
		}				
	}

}
