<?php
require_once 'erpinterface.php';
/**
 * Data class to interact with efisa DB
 */
class mysql_efisa implements erpinterface {

	private $db;

	/**
	 * Class constructor
	 */
	public function __construct() {

		$mysqli = new mysqli(CONFIG_DB_HOST, CONFIG_DB_USER, CONFIG_DB_PASS, CONFIG_DB_NAME);

		/* check connection */
		if (mysqli_connect_errno()) {
		    printf("Connect failed: %s\n", mysqli_connect_error());
		    exit();
		}

		$this->db = $mysqli;

	}

	/**
	 * Gets the products to be updated from ERP to WOO
	 * @return array List of products to update
	 */
	public function get_products() : array {

		$stmt = $this->db->prepare("SELECT * FROM `products` WHERE status = 1");

		$stmt->execute();

		$result = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

		//echo "Recibimos de la DB <br><pre>".print_r($result,1)."</pre>";

		return $result;

	}

	/**
	 * Updates the wp id of a product
	 * @param  string $sku ID in ERP
	 * @param  int    $wp_id  ID in Woo
	 * @param  string $notes  Notes if unable to find/create product
	 * @return bool 		  true if updated
	 */
	public function update_product_id($sku, $wp_id, $notes) : bool {

		$stmt = $this->db->prepare("UPDATE `products` SET `id_wp`=?, `notes`=? WHERE `sku` = ?");

		$stmt->bind_param("sss", $wp_id, $notes, $sku);

		$stmt->execute();
		$stmt->close();

		return true;

	}

	/**
	 * Resets a wordpress ID to attempt to find product again or create it
	 * @param  integer $wp_id the woo id to reset
	 */
	public function reset_wp_id($wp_id) : bool {

		$stmt = $this->db->prepare("UPDATE `products` SET `id_wp`=-1 WHERE `id_wp` = ?");

		$stmt->bind_param("s", $wp_id);

		$stmt->execute();
		$stmt->close();

		return true;

	}

	/**
	 * Closes de DB connection
	 */
	public function close_connection() {

		$this->db->close();

	}

	/**
	 * Logs event to the corresponding log table
	 * @param  string $severity Severity of the message
	 * @param  string $message  Message to log
	 */
	public function log_event($severity, $message) {
		$stmt = $this->db->prepare("INSERT INTO `log` (`severity`, `message`) VALUES (?, ?)");

        $stmt->bind_param("ss", $severity, $message);

        $stmt->execute();
        $stmt->close();
	}

	/**
	 * Sets the status of a product
	 * @param string  $sku the sap_id
	 * @param integer $status the status to be set
	 */
	public function set_status($sku, $status = 2) : bool {

		$stmt = $this->db->prepare("UPDATE `products` SET `status`=? WHERE `sku` = ?");

		$stmt->bind_param("ss", $status, $sku);

		$stmt->execute();
		$stmt->close();

		return true;

	}

}