<?php

interface erpinterface {

	/**
	 * Get all the products form the ERP that NEED updating
	 * @return array List of products with at least sku (sku), wp_id (wordpress id), price, name, stock
	 */
	public function get_products() : array;

	/**
	 * Update a product's wp id to keep cached id for optimization
	 * @param  string 	$sku SKU or id in ERP
	 * @param  int 		$wp_id  Id in wordpress/woocommerce
	 * @param  string 	$notes  any relevant notes to add (optional to record)
	 * @return bool 			result of update
	 */
	public function update_product_id($sku, $wp_id, $notes) : bool;

	/**
	 * Reset a Wordpress ID in case the product was no longer found
	 * @param  id 		$wp_id the wordpress id to reset
	 * @return bool     	   result of the operation
	 */
	public function reset_wp_id($wp_id) : bool;

	/**
	 * Closes the connection to db or any other technology
	 */
	public function close_connection();

	/**
	 * Logs an event in whichever technology the interface implements (ideally a DB)
	 * @param  string $severity Severity of the event
	 * @param  string $message  Message to log
	 */
	public function log_event($severity, $message);

	/**
	 * Set status of a product. Normally = 2 marks the product as processed and updated in wp
	 * @param string 	$sku id of processed product
	 * @param int 		$status status to set
	 * @return bool 			result of operation
	 */
	public function set_status($sku, $status) : bool;
}