<?php 
class category 
{
    public $name;
    public $id_wp;
    public $parent;
    public $categories = array();

    function __construct($name, $id_wp = 0, $parent = null, $categories = array())
    {
        $this->name = $name;
        $this->id_wp = $id_wp;
        $this->parent = $parent;
        $this->categories = $categories;
    }
}

class category_controller 
{
    private $erp;
    private $woo;
    private $root;
    private $category_list;

    function __construct($woo_connection, $erp_connection) 
    {
        $this->woo = $woo_connection;
		$this->erp = $erp_connection;
        $this->root = new category('root');
        $this->category_list[0] = $this->root;
        $this->load_categories();
	}

    function load_categories()
    {   
        $categories = $this->erp->get_categories();

        foreach($categories as $cat) {
            $this->add_category_to_tree($cat);
        }
    }

    function add_category_to_tree($cat) 
    {
        $parent = null;

        if (isset($this->category_list[$cat['id_parent']])) {
            $parent = $this->category_list[$cat['id_parent']];
        } else {
            $parent = new category('');
            $this->category_list[$cat['id_parent']] = $parent;
        }

        if (isset($this->category_list[$cat['id_wp']])) {
            $this->category_list[$cat['id_wp']]->name = $cat['name'];
            $this->category_list[$cat['id_wp']]->id_wp = $cat['id_wp'];
            $this->category_list[$cat['id_wp']]->parent = $parent;
            $parent->categories[$cat['name']] = $this->category_list[$cat['id_wp']]; 
        } else {
            $new_cat = new category($cat['name'], $cat['id_wp'], $parent);
            $parent->categories[$cat['name']] = $new_cat;

            $this->category_list[$cat['id_wp']] = $new_cat;
        }
    }

    function get_id($names)
    {
        $current_category = $this->root;

        for ($i = 0; $i < count($names); $i++) {
            if ( isset($current_category->categories[$names[$i]]) ) {
                $current_category = $current_category->categories[$names[$i]];
            } else {
               $current_category = $this->get_category($current_category, $names[$i]);
            }
        } 

        return $current_category->id_wp;
    }

    function get_category($parent, $name)
    {
        try {
            $category = null;

			$categories = $this->woo->get('products/categories', array('parent'=>$parent->id_wp, 'search'=>$name));
            
            foreach ($categories as $cat_temp) {
                if ($cat_temp->name == $name) {
                    $category = array(
                        0 => $cat_temp
                    );
                }
            }

            if ($category) {
                $newcat = new category($category[0]->name, $category[0]->id, $parent);
                $parent->categories[$name] = $newcat;
                $this->erp->save_category($category[0]->id ,$category[0]->parent, $category[0]->name);
                return $newcat;
			} else {
                $data = array(
                    'name' => $name,
                    'parent' => $parent->id_wp
                );

                $add_category = $this->woo->post('products/categories', $data);
                $newcat = new category($add_category->name, $add_category->id , $parent);
                $parent->categories[$name] = $newcat;
                $this->erp->save_category($add_category->id, $add_category->parent, $add_category->name);
                return $newcat;
			}

		} catch (HttpClientException $e) {
			$this->output_woo_exception($e);
			return -1;
		}
    }
}